<div class="ulz-mod-listing ulz-mod-listing-author" data-type="author">
    @if( ! empty( $name ) )
        <h4>{{ $name }}</h4>
    @endif
    <div class="ulz-author">
        <div class="ulz--heading">
            <div class="ulz--avatar">
                <a href="{{ get_author_posts_url( $user->id ) }}">
                    {!! $user->avatar() !!}
                </a>
            </div>
            <div class="ulz--meta">
                <div class="ulz--name">
                    <a href="{{ get_author_posts_url( $user->id ) }}">
                        {{ $userdata->display_name }}
                    </a>
                    @if( $total_reviews )
                        <div class="ulz--reviews">
                            <i class="fas fa-star"></i>
                            <span>{{ sprintf( _n( $strings->review, $strings->reviews, $total_reviews, 'utillz-core' ), $total_reviews ) }}</span>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        @if( $user_description )
            <div class="ulz--description">
                {!! wpautop( $user_description ) !!}
            </div>
        @endif
        @if( $display_contact || $display_public_profile )
            <div class="ulz--action">
                @if( $display_contact )
                    <a href="#" class="ulz-button" data-modal="{{ is_user_logged_in() ? 'conversation' : 'signin' }}" data-params='{"id":{{ $listing->id }}}'>
                        <i class="material-icons ulz-mr-1">chat</i>
                        <span>{{ sprintf( $strings->contact, $userdata->display_name ) }}</span>
                    </a>
                @endif
                @if( $display_public_profile )
                    <a href="{{ $user_public_url }}" class="ulz-button" target="_blank">
                        <i class="material-icons ulz-mr-1">person</i>
                        <span>{{ $strings->public_profile }}</span>
                    </a>
                @endif
            </div>
        @endif
    </div>
</div>
